************************* HILDA MERGE CODE - individuals************************
******************************* DATE: MAY 2019 ********************************
**************************** AUTHOR: FIONA PRICE ******************************

///This do file provides code to obtain unbalanced and balanced merged data files that contain the HILDA variables of interest for all persons in the HILDA Surveys///
///IMPORTANT: update the first section as directed but do not change any of the code in the other sections//
///RUN WHOLE CODE, DO NOT RUN SECTIONS OF CODE OR LOCAL VARIABLES WILL DISAPPEAR///

clear all
set more off
set maxvar 30000

********************************************************************************
************************** 1. Parts to change **********************************
********************************************************************************

**set up local directories // update as necessary
local hildadir "C:\"
local analysisdir "C:\"

**choose name for output files
local unbalancedname "\Unbalanced" //the final term here is the name of your unbalanced output file. Keep the backslash
local balancedname "\Balanced" ///the final term here is the name of your balanced output file. Keep the backslash

**make sure local variables for waves are up-to-date 
local prefix a b c d e f g h i j k l m n o p q // add new wave to end as appropriate (a-wave 1; p-Wave 16)
local waveno 17 // update this to latest wave number
local wavepre q // update this to latest wave prefix
local waves XXXXXXXXXXXXXXXXX // Number of X's should equal number of waves

**choose HILDA variables you want to have in your main data file
local varstokeep  hhpno hhpid hhrhid hgdob hhfxid hhmxid hhbmxid hhbfxid hhidpw xwaveid hhid year hhrih hgage hgsex wave hhpxid hhpers hhtype hhfam hhmove tifdip tifdin edhigh1 hhtup hgdob hhfxid hhmxid hhbmxid hhbfxid hhidpw ///
	hgint hhiu hhresp hhrih hhwtrp hhpers mhrealb  hh0_4 hh5_9  hh10_14 hhpcode hslnoth hhid  hhrih hhpid hgint hhpno hslnoth hhadult hhwth hglth ghpf lsdrka lspact lssmkf lstbcn ///  Interview variables 
	hgage hgsex ancob hhstate hhmsr hhsos mrcurr anatsi anengf tcr tcnr tchad tcr04 tcr514 anyoa mhnyr fiprosp hhssa4 fiemerf fibfin hhsad10 bmhtcm bmwt bmi /// Demographic variables 
	esempst  es esdtl esbrd jbcasab capune ehtjbyr ehtjb hhura jbmssec nlrealt jbmpg nlan4wk ujlji61 jst hges helth fmfo6s rtmrea /// Employment variables 
    wsfg wsfga wsfna bifiga wsfef wsfei wscei hifdip hifdin /// Wages and salary variables
    bifuga bifip bifin biff /// Business Income
    oifinta oifrnta oifroya oifdiva bifdiva oifinip oifinin oifinf oiinti opchk oifrnt oprnty oprntn /// Investment Income  
	oifsupi oifwkci oifppi oifppf  /// Private Pensions
	tifmkip tifmkin /// Regular market income 
    tifpiip tifpiin /// Regular private Income 
    oifchs oifnptr oifohha oifpria  oifpti oifptf oifpnt oifpnta  /// Private Tranfers
    bnfpeni bnfpari bnfalli bnfisi  bnffama  bnfonii bnfnisi bnfisf bnfobi bnfapti bnfaptf  /// Aust. Govt. Public Transfers
    bnfrpi bnffpi oifrsvi oifinha oifnpt oifrpt oifohhl oiflswa oifpria oifoiri oifwfli /// Irregular Income 
    tifeftp tifeftn txtottp txtottn tifditp tifditn  /// Gross Total Income measures (inc. Irr.)
    tifefp tifefn   txtotp txtotn tifdip tifdin  /// Gross Total Income measures (exc. Irr.)
	edhigh edfts edagels edhists edtypes jbmploj jbmplej jbmpgj jbempt jbmo62 jbmo61 jbmcnt jbmtuea jbn jbocct jbmi61 jbmi62 jbmii2 jbemlwk jbmhruc jbprhr jbtprhr  jbptrea jbhrcpr jbhrqf jbhruc ehtujyr hhwtrp hhsed10 /// 
	hsvalue  hsmgowe hsten hsrnti hsmgi hssli hsmgpd hsmguse hsslowe hsslf hsmgf fmagelh hslnoth lshrcom gh1 hsmgfin hhsra pjoto61 ujljo61 /// other variables 
	mhreaas mhreabn mhreaff mhreals mhreahn mhrealb mhrealw mhreanj mhreaob mhreawr mhreawp mhrearb mhreapo mhreaev mhreagh mhreafm mhreahr mhreamb mhreamr mhreaos mhreapf mhreapn mhreasm mhreawt losatlc ///moving
	jbmmply lefrd pjmsemp pjoii2 pjljr pjljrea pjsemp jbmhrua jbmhruw jbhruw jbhrua anatsin lnwtrp hhmove lertr hhmove hhmovek jbmwpsz hhtup hhtuh hifboni hifbonf bnfboni bnfonf bnfbon ssfai ssfaf ssfa ///
	jbawmhr hhwthm hhwtrpm  jbmhrv jbmhru jbhrv jbhru  hspown bnfboni rtcomp ///
	hwnwip hwnwin hwassei hwdebti hwfini hwnfii hwtpvi hwsupei hwtbani hsyr hwopdti hsloana hsprice tifditp tifditn hwassei hwdebti hwfini hwhmdti hwhmvai hwtpdi hwtpvi hwtbani hweqini hwcaini hwccdti hsevref hsmglt hsrefy ///
	hxyalc hxycig hxyeduc hxygroc  hxyhmrn hxymeal hxymvf hxymvr hxypbti hxyphi hxypubt hxyutil hsmgsch ///
	hxyhltp hxyoi hxyphrm hxyteli hxywcf hxyccf hxymcf hxycomp hxyfurn hxyhol hxyncar hxytvav hxyucar hxywg rpage ///
	fiprbeg fiprbfh fiprbmr fiprbps fiprbuh fiprbwm fiprbwo firisk jttnum jttrwrk fisave fisavep fisedch fishlpc pntrisk firisk fiprosp fiprbeg fiprbmr fiprbps fiprbwm fiprbuh fiprbfh fiprbwo rtage fipreg fiprmr fiprps fiprwm fipruh fiprfh fiprwo  ///
///DO NOT MAKE ANY CHANGES TO THE FILE BEYOND THIS POINT///

********************************************************************************
************************* 2. Create unbalanced panel ***************************
********************************************************************************

* Create temporary data files with selected variables for each wave
local i = 0
foreach w of local prefix {
	use "`hildadir'\Combined_`w'170u" // Note: make sure file name matches the newest wave

	renpfix `w'      // Strip off wave prefix
	local i = `i'+1  // Increase (wave) counter by 1
 	gen wave = `i'   // Create wave indicator
	gen year = 2000 + wave	// Create year variable

	if ("`varstokeep'"!="") {
		local tokeep								// empty to keep list
		foreach var of local varstokeep {			// loop over all selected variables
			capture confirm variable `var'			// check whether variable exists in current wave
			if (!_rc) local tokeep `tokeep' `var'	// mark for inclusion if variable exists
			}
		keep xwaveid wave year `tokeep'				// keep selected variables
        }

	tempfile tempdata_`w' // Save temporary data file
	save "`tempdata_`w''"
}
label variable wave "Survey wave"

* Append the temporary data files for each wave to create unbalanced panel
clear
foreach w of local prefix {
	append using "`tempdata_`w''"
	}

order xwaveid wave
sort  xwaveid wave

tab wave // Check for any obvious errors in observations in each wave

** Save the unbalanced data file you can then use for your analysis
save "`analysisdir'`unbalancedname'", replace
use "`hildadir'\Master_`wavepre'`waveno'0u"
keep xwaveid ivwptn yob dob aadeath mcdeath yodeath
merge 1:m xwaveid using "`analysisdir'`unbalancedname'", nogen
save "`analysisdir'`unbalancedname'", replace

********************************************************************************
************************** 3. Create balanced panel ****************************
********************************************************************************

// use unbalanced file and keep only those observed in all waves
use "`hildadir'\Master_`wavepre'`waveno'0u"
keep xwaveid ivwptn yob dob aadeath mcdeath yodeath
merge 1:m xwaveid using "`analysisdir'`unbalancedname'", nogen
keep if ivwptn=="`waves'" // keep persons responding in every wave; 
								// there should be as many 'X's as there are waves
order xwaveid wave
sort  xwaveid wave

tab wave // Check equal number of observations in ecah wave

** Save the balanced data file you can then use for your analysis
save "`analysisdir'`balancedname'", replace
